<?php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: login.php");
    exit();
}

$dataFile = "data.json";
$data = json_decode(file_get_contents($dataFile), true);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data['pmValue'] = $_POST['pmValue'];
    $data['pmToday'] = $_POST['pmToday'];
    $data['pmYesterday'] = $_POST['pmYesterday'];
    file_put_contents($dataFile, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    echo "ذخیره شد ✅<br>";
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>پنل مدیریت</title>
</head>
<body>
  <h2>پنل مدیریت</h2>
  <form method="post">
    <label>اکنون:</label>
    <input type="number" name="pmValue" value="<?= $data['pmValue'] ?>"><br><br>
    <label>امروز:</label>
    <input type="number" name="pmToday" value="<?= $data['pmToday'] ?>"><br><br>
    <label>دیروز:</label>
    <input type="number" name="pmYesterday" value="<?= $data['pmYesterday'] ?>"><br><br>
    <button type="submit">ذخیره</button>
  </form>
  <br>
  <a href="logout.php">خروج</a>
</body>
</html>
