const ARC_LENGTH = 410;

function getStatus(pm) {
  if (pm <= 50) return {color:"#00e400", label:"پاک"};
  if (pm <= 100) return {color:"#ffff00", label:"قابل قبول"};
  if (pm <= 150) return {color:"#ff7e00", label:"ناسالم برای گروه‌های حساس"};
  if (pm <= 200) return {color:"#ff0000", label:"ناسالم"};
  if (pm <= 300) return {color:"#8f3f97", label:"بسیار ناسالم"};
  return {color:"#7e0023", label:"خطرناک"};
}

function renderStation(station) {
  const st = getStatus(station.pmValue);
  const fraction = Math.min(station.pmValue/500,1);

  return `
    <div class="card">
      <h3>${station.name}</h3>
      <div class="gauge">
        <svg viewBox="0 0 300 160">
          <path class="arc-bg" d="M20,140 A130,130 0 0 1 280,140" stroke-width="16"/>
          <path class="arc-value" d="M20,140 A130,130 0 0 1 280,140"
                stroke="${st.color}" stroke-width="16"
                stroke-dasharray="${(ARC_LENGTH*fraction).toFixed(1)} ${ARC_LENGTH}"/>
        </svg>
      </div>
      <div class="value">اکنون: ${station.pmValue}</div>
      <div class="label" style="color:${st.color}">${st.label}</div>
      <div>امروز: ${station.pmToday}</div>
      <div>دیروز: ${station.pmYesterday}</div>
    </div>
  `;
}

fetch("data.json")
  .then(res => res.json())
  .then(data => {
    document.querySelector(".wrap").innerHTML = `
      <h1>شاخص آلودگی هوا - ${data.region}</h1>
      ${data.stations.map(renderStation).join("")}
    `;
  });
